*** Figure 5: Estimates on the Behavior of White Voters

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 


use  "$data/dta_forfig_5.dta", clear


// To plot 
gen white_switchers=whitevotingDems60-potential_white_dems60
*replace white_switchers=0 if white_switchers<0

// vars to plot
gen black_increase=654
gen sw_whites=white_switchers/black_increase *10
replace sw_whites=round(sw_whites,1)


// Create vars for 0 switchers area

bys blackDVS60: egen low= min(blackturnout60) if sw_whites==0

twoway  (contour sw_whites blackturnout60 blackDVS60 , crule(intensity) levels(17)  ecolor(gs3) ) || ///
		(rarea low low blackDVS60 , fcolor(none) lcolor(black) lwidth(medium) lpattern(solid)) || ///
		(scatter blackturnout60 blackDVS60 if (float(blackDVS60) == float(0.72) &float(blackturnout60) == float(0.45)), msymbol(X) msize(large) mcolor(maroon) mlw(medthick) ), ///
ylabel(0(.2)1) plotregion(style(none)) ztitle("White switchers (per 10 Black migrants)", size(small))  zlabel(, labsize(small)) legend(off) graphregion(fcolor(white) ilcolor(white) lcolor(white)) ///
ytitle("Turnout among non-southern Black residents", size(small)) ///
xtitle("Democratic Vote Share among non-southern Black residents", size(small)) 
		
graph export "$output/Figure5.eps", replace
	
	
